module exercise6

import StdEnv, StdiTasks, iDataTrivial

Start world = singleUserTask [] (foreverTask exercise6) world



exercise6 :: Task Void
exercise6 
= 					[Txt "Enter a number: ", Br, Br]
					?>> editTask "OK" 0
					<|  (\result -> (isPrime result,showError result))
 =>> \prime ->		[Txt (prime +++> " is a prime number."), Br]
 					?>> editTask "OK" Void					

isPrime :: Int -> Bool
isPrime n 
| n <= 1 	= False
| otherwise = isMember n (takeWhile (\m -> m <= n) primes)

primes :: [Int]
primes = sieve [2..]
where
	sieve [prime:rest] = [prime : sieve (filter prime rest)]
	
	filter p [h:tl]	| h rem p == 0	= filter p tl
									= [h : filter p tl]
	filter p []						= []

showError :: Int -> HtmlCode
showError n = [Txt (n +++> " is not a prime number"), Br, Br]					
